<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Inertia\Inertia;
use App\Models\Conversation; // Import the Conversation model
use App\Models\Message; // Import the Message model

class ConversationController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $conversations = Conversation::with(['user', 'doctor'])
            ->latest('last_message_at')
            ->paginate(10);

        return Inertia::render('Admin/Conversations/Index', [
            'conversations' => $conversations,
        ]);
    }

    /**
     * Display the specified resource.
     */
    public function show(Conversation $conversation)
    {
        $conversation->load(['user', 'doctor', 'messages.sender']); // Load relationships
        return Inertia::render('Admin/Conversations/Show', [
            'conversation' => $conversation,
            'messages' => $conversation->messages,
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        // This will be handled by a separate method for sending messages within a conversation
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}