<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Inertia\Inertia;
use App\Models\Slider;
use App\Models\Service;
use App\Models\Portfolio;
use App\Models\Team;
use App\Models\Setting;
use App\Models\Event;
use App\Models\Product;
use App\Models\SchoolService;

class HomeController extends Controller
{
    public function index()
    {
        $sliders = Slider::latest()->limit(6)->get();
        $services = Service::latest()->limit(6)->get();
        $portfolios = Portfolio::orderBy('order')->get();
        $teams = Team::orderBy('order')->get();
        $setting = Setting::firstOrCreate([]);
        $events = Event::latest()->limit(6)->get(); // Fetch all events
        $products = Product::latest()->limit(6)->get(); // Fetch all products
        $schools = SchoolService::latest()->limit(6)->with('instructor')->get(); // Fetch all school services with instructor relationship

        return Inertia::render('Welcome', [
            'sliders' => $sliders,
            'setting' => $setting,
            'services' => $services,
            'portfolios' => $portfolios,
            'teams' => $teams,
            'events' => $events, // Pass events data
            'products' => $products, // Pass products data
            'schools' => $schools, // Pass school services data
        ]);
    }
}