<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use App\Models\SchoolService;
use Illuminate\Http\Request;
use Inertia\Inertia;
use App\Models\SchoolServiceBooking;
use App\Models\SchoolServiceBookingDetail;
use Illuminate\Support\Facades\Auth;

class SchoolServiceBookingController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $user = Auth::user();

        $schoolServiceBookings = SchoolServiceBookingDetail::where('user_id', $user->id)->with('schoolService')->latest()->paginate(10);

        $schoolServiceBookings->getCollection()->transform(function ($schoolServiceBooking) {
            return [
                'id' => $schoolServiceBooking->id,
                'service_name' => $schoolServiceBooking->schoolService->name,
                'booking_date' => $schoolServiceBooking->created_at->format('Y-m-d'),
                'status' => $schoolServiceBooking->status,
            ];
        });

        return Inertia::render('User/SchoolServiceBookings/Index', [
            'schoolServiceBookings' => $schoolServiceBookings,
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $schoolServices = \App\Models\SchoolService::all();

        return Inertia::render('User/SchoolServiceBookings/Create', [
            'schoolServices' => $schoolServices,
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'school_service_id' => 'required|exists:school_services,id',
            'notes' => 'nullable|string',
        ]);

        $schoolService = SchoolService::find($request->school_service_id);

        if ($schoolService->type !== 'free') {
            // Store booking data in session and redirect to payment
            session([
                'booking_data' => [
                    'user_id' => Auth::id(),
                    'school_service_id' => $request->school_service_id,
                    'notes' => $request->notes,
                    'amount' => $schoolService->price,
                    'type' => 'school_service',
                ]
            ]);
            return redirect()->route('paypal.initiate'); // Or a generic payment page
        }

        $booking = SchoolServiceBookingDetail::create([
            'user_id' => Auth::id(),
            'school_service_id' => $request->school_service_id,
            'notes' => $request->notes,
        ]);

        return redirect()->route('user.school-service-bookings.index')->with('success', 'School service booked successfully.');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
