<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\Order;
use App\Models\Booking;
use App\Models\Notification;
use Inertia\Inertia;

class UserDashboardController extends Controller
{
    public function index()
    {
        $user = Auth::user();

        // Fetch recent orders for the authenticated user
        $recentOrders = Order::where('user_id', $user->id)
                            ->latest()
                            ->take(5)
                            ->get();

        // Fetch recent bookings for the authenticated user
        $recentBookings = Booking::where('user_id', $user->id)
                                ->latest()
                                ->take(5)
                                ->get();

        // Fetch unread notifications for the authenticated user
        $unreadNotifications = $user->unreadNotifications;

        // Fetch booking counts
        $completedBookingsCount = Booking::where('user_id', $user->id)
                                        ->where('status', 'completed')
                                        ->count();
        $pendingBookingsCount = Booking::where('user_id', $user->id)
                                      ->where('status', 'pending')
                                      ->count();

        return Inertia::render('User/Dashboard', [
            'user' => $user,
            'recentOrders' => $recentOrders,
            'recentBookings' => $recentBookings,
            'unreadNotifications' => $unreadNotifications,
            'completedBookingsCount' => $completedBookingsCount,
            'pendingBookingsCount' => $pendingBookingsCount,
        ]);
    }
}
