<?php

namespace App\Http\Middleware;

use Illuminate\Http\Request;
use Inertia\Middleware;
use Darryldecode\Cart\Facades\CartFacade as Cart;

class HandleInertiaRequests extends Middleware
{
    /**
     * The root template that is loaded on the first page visit.
     *
     * @var string
     */
    protected $rootView = 'app';

    /**
     * Determine the current asset version.
     */
    public function version(Request $request): ?string
    {
        return parent::version($request);
    }

    /**
     * Define the props that are shared by default.
     *
     * @return array<string, mixed>
     */
    public function share(Request $request): array
    {
        return [
            ...parent::share($request),
            'auth' => [
                'user' => $request->user(),
                'last_login_at' => $request->user() ? $request->user()->last_login_at : null,
                'unreadNotifications' => $request->user() ? $request->user()->unreadNotifications : [],
            ],
            'cartItems' => Cart::getContent()->toArray(),
            'cartTotal' => Cart::getTotal(),
            'cartCount' => Cart::getContent()->count(),
        ];
    }
}
