<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class RoleMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next, ...$roles): Response
    {
        if (!auth()->check()) {
            return redirect('/login');
        }

        $user = auth()->user();

        foreach ($roles as $role) {
            if ($role === 'admin' && $user->role >= 500) { // System Admin
                return $next($request);
            }

            if ($role === 'doctor' && $user->role == 200) { // Doctor
                return $next($request);
            }

            if ($role === 'user' && $user->role >= 100 && $user->role < 200) { // Regular User
                return $next($request);
            }
        }

        abort(403, 'Unauthorized action.');
    }
}
