<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class BookingStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return Auth::check(); // Only authenticated users can make a booking
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'bookable_id' => ['required', 'string'], // Assuming UUIDs for bookable models
            'bookable_type' => ['required', 'string', 'in:App\\Models\\Event,App\\Models\\SchoolService,App\\Models\\Service'],
            'price' => ['required', 'numeric', 'min:0'],
            'quantity' => ['required', 'integer', 'min:1'],
            'booking_date' => ['nullable', 'date', 'after_or_equal:today'],
            'booking_time' => ['nullable', 'string'],
            'notes' => ['nullable', 'string', 'max:500']
        ];
    }
}

