<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EventBookingDetail extends Model
{
    use HasFactory, HasUuids;

    protected $fillable = [
        'booking_id',
        'name',
        'email',
        'attendees',
        'notes',
        'event_id',
        'price',
        'user_id',
    ];

    public function booking()
    {
        return $this->belongsTo(Booking::class);
    }

    public function event()
    {
        return $this->belongsTo(Event::class);
    }
}
