<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Gallery extends Model
{
    use HasFactory, HasUuids;

    protected $fillable = [
        'title',
        'description',
        'image_path',
        'order',
        'url',
    ];

    protected $appends = ['image_url'];

    public function getImageUrlAttribute()
    {
            return 'storage/' . $this->image_path;
    }
}
