<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SchoolServiceBookingDetail extends Model
{
    use HasFactory, HasUuids;

    protected $fillable = [
        'booking_id',
        'phone_number',
        'doctor_id'
    ];

    public function booking()
    {
        return $this->belongsTo(Booking::class);
    }

    public function schoolService()
    {
        return $this->belongsTo(SchoolService::class);
    }
}
