<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphMany;

class Service extends Model
{
    use HasUuids;
    protected $fillable = ['title', 'description', 'icon', 'order', 'image_path', 'type', 'price', 'is_visible', 'image_url'];

    /**
     * The accessors to append to the model's array form.
     *
     * @var array
     */
    protected $appends = ['image_url'];

    /**
     * Get the URL of the service's image.
     *
     * @return string
     */
    public function getImageUrlAttribute()
    {
        if ($this->image_path) {
            return $this->image_path;
        }
        return 'https://via.placeholder.com/150'; // Placeholder image
    }

    /**
     * Get all of the service's order items.
     */
    public function orderItems(): MorphMany
    {
        return $this->morphMany(OrderItem::class, 'item');
    }
}
