<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Setting extends Model
{
    use HasFactory, HasUuids;

    protected $fillable = [
        'logo_path',
        'logo_url',
        'company_name',
        'email',
        'phone',
        'address',
        'facebook_link',
        'twitter_link',
        'linkedin_link',
        'instagram_link',
        'youtube_link',
        'years_of_experience',
        'happy_clients',
        'projects_completion',
        'about_us_description',
        'mission',
        'vision',
        'innovation',
        'teamwork',
        'growth',
        'excellence',
        'speed',
        'integrity',
    ];

    protected $casts = [
        'payment_gateways' => 'array',
    ];
}
