import React from 'react';

export default function ApplicationLogo(props) {
    // Primary brand green
    const brandGreen = "#4CAF50"; 
    // Dark color for contrast
    const brandBlack = "#212121"; 
    // White for highlights
    const brandWhite = "#FFFFFF";

    return (
        <svg
            {...props}
            viewBox="0 0 200 200" // Standard viewBox
            xmlns="http://www.w3.org/2000/svg"
            fill="currentColor" 
        >
            {/* 1. Main Background Shape (representing 'Balm'/'Container') */}
            {/* Using a modern, slightly rounded square shape in dark black for stability and contrast */}
            <rect 
                x="20" y="20" width="160" height="160" 
                rx="30" ry="30" // Rounded corners
                fill={brandBlack} 
            />

            {/* 2. Letter 'P' (representing 'Promise') */}
            {/* Tall, clean line and a curved top in the brand Green */}
            <path 
                d="M50 40 L50 160 M50 40 A40 40 0 0 1 100 80 L90 80 A30 30 0 0 0 60 50"
                stroke={brandGreen}
                strokeWidth="15"
                fill="none"
                strokeLinecap="round"
                strokeLinejoin="round"
            />
            
            {/* 3. Letter 'B' (representing 'Balm') */}
            {/* Designed to overlap or align with the 'P' line in White for a clean break/overlap effect */}
            <path 
                d="M105 40 L105 160 M105 40 A35 35 0 0 1 155 75 M105 85 A40 40 0 0 1 155 125 M105 160 L140 160"
                stroke={brandWhite}
                strokeWidth="15"
                fill="none"
                strokeLinecap="round"
                strokeLinejoin="round"
            />

            {/* Final Touch: A small, hidden green circle for a 'balm/drop' effect on the 'B' curve */}
            <circle cx="155" cy="75" r="5" fill={brandGreen} />
            <circle cx="155" cy="125" r="5" fill={brandGreen} />
            
        </svg>
    );
}