import { Link } from '@inertiajs/react';

export default function NavLink({
    active = false,
    className = '',
    children,
    ...props
}) {
    return (
        <Link
            {...props}
            className={
                'group flex items-center px-3 py-2.5 text-sm font-medium rounded-lg transition-all duration-200 ' +
                (active
                    ? 'bg-gray-800 text-white'
                    : 'text-gray-300 hover:text-white hover:bg-gray-800') +
                ' focus:outline-none focus:text-white focus:bg-gray-800 ' +
                className
            }
        >
            {children}
            {active && (
                <span className="ml-auto w-2 h-2 bg-green-500 rounded-full"></span>
            )}
        </Link>
    );
}