import Preloader from '@/Components/Preloader';
import React, { useEffect, useState } from 'react';
import Navbar from '@/Components/Navbar';
import { usePage } from '@inertiajs/react';
import Footer from '@/Components/Footer';

export default function HomeLayout({ children }) {
    const { auth } = usePage().props;
    const [loading, setLoading] = useState(true);

    useEffect(() => {
        const timer = setTimeout(() => {
            setLoading(false);
        }, 1000);

        return () => clearTimeout(timer);
    }, []);

    if (loading) {
        return <Preloader />;
    }
    return (
        <div className="min-h-screen bg-gray-100">
            <Navbar auth={auth} />
            <main>{children}</main>

            <Footer />
        </div>
    );
}