import { useState } from 'react';
import { Link, usePage } from '@inertiajs/react';
import NavLink from '@/Components/NavLink';
import Dropdown from '@/Components/Dropdown';
import { ChevronDownIcon, ChevronRightIcon, BellIcon, Cog6ToothIcon, DocumentTextIcon, XMarkIcon } from '@heroicons/react/24/outline'; 
import { motion } from 'framer-motion';

const adminNavigationData = [
    // Admin specific links
    {
        name: 'Dashboard',
        href: "",
        icon: (
            <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path strokeLinecap="round" strokeLinejoin="round" strokeWidth="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6" />
            </svg>
        ),
        activeMatch: 'dashboard',
    },
    // {
    //     name: 'Notifications',
    //     href: route('admin.notifications.index'),
    //     activeMatch: 'admin.notifications.*',
    //     icon: (
    //         <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
    //             <path strokeLinecap="round" strokeLinejoin="round" strokeWidth="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"></path>
    //         </svg>
    //     )
    // },
    // {
    //     name: 'Conversations',
    //     href: route('admin.conversations.index'),
    //     activeMatch: 'admin.conversations.*',
    //     icon: (
    //         <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
    //             <path strokeLinecap="round" strokeLinejoin="round" strokeWidth="2" d="M8 10h.01M12 10h.01M16 10h.01M9 16H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-5l-5 5v-5z"></path>
    //         </svg>
    //     )
    // },
    {
        name: 'Services',
        href: route('admin.services.index'),
        icon: (
            <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path strokeLinecap="round" strokeLinejoin="round" strokeWidth="2" d="M21 13.255A23.931 23.931 0 0112 15c-3.183 0-6.22-.62-9-1.745M16 6V4a2 2 0 00-2-2h-4a2 2 0 00-2 2v2m4 6h.01M5 20h14a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" />
            </svg>
        ),
        activeMatch: 'admin.services.*',
    },
    {
        title: 'Product Management',
        // ADDED ICON FOR GROUP TITLE
        icon: (
            <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path strokeLinecap="round" strokeLinejoin="round" strokeWidth="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z" />
            </svg>
        ),
        items: [
            {
                name: 'All Products',
                href: route('admin.products.index'),
                icon: (
                    <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path strokeLinecap="round" strokeLinejoin="round" strokeWidth="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z" />
                    </svg>
                ),
                activeMatch: 'admin.products.*',
                hasNotification: true,
            },
            {
                name: 'Categories',
                href: route('admin.product-categories.index'),
                icon: (
                    <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path strokeLinecap="round" strokeLinejoin="round" strokeWidth="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z" />
                    </svg>
                ),
                activeMatch: 'admin.product-categories.*',
            },
        ],
    },
    {
        name: 'Events',
        href: route('admin.events.index'),
        activeMatch: 'admin.events.*',
        icon: (
            <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                <path strokeLinecap="round" strokeLinejoin="round" strokeWidth="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
            </svg>
        )
    },
    {
        name: 'School',
        href: route('admin.school-services.index'),
        activeMatch: 'admin.school-services.*',
        icon: (
            <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                <path strokeLinecap="round" strokeLinejoin="round" strokeWidth="2" d="M12 6.253v13m0-13C10.832 5.477 9.206 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.832 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.794 5 16.5 5s3.332.477 4.5 1.253v13C19.832 18.477 18.168 18 16.5 18s-3.332.477-4.5 1.253"></path>
            </svg>
        )
    },
    {
        name: 'Teams',
        href: route('admin.teams.index'),
        activeMatch: 'admin.teams.*',
        icon: (
            <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                <path strokeLinecap="round" strokeLinejoin="round" strokeWidth="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
            </svg>
        )
    },
    {
        name: 'Doctors',
        href: route('admin.doctors.index'),
        activeMatch: 'admin.doctors.*',
        icon: (
            <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                <path strokeLinecap="round" strokeLinejoin="round" strokeWidth="2" d="M12 4.354a4 4 0 110 5.292M15 21H9a2 2 0 01-2-2V7a2 2 0 012-2h6a2 2 0 012 2v12a2 2 0 01-2 2zm-2-4h.01"></path>
            </svg>
        )
    },
    {
        name: 'Order Management',
        href: route('admin.orders.index'),
        activeMatch: 'admin.orders.*',
        icon: (
            <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                <path strokeLinecap="round" strokeLinejoin="round" strokeWidth="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-3 7h3m-3 4h3m-6-4h.01M9 16h.01"></path>
            </svg>
        )
    },
    {
        name: 'Bookings',
        href: route('admin.bookings.index'),
        activeMatch: 'admin.bookings.*',
        icon: (
            <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                <path strokeLinecap="round" strokeLinejoin="round" strokeWidth="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-3 7h3m-3 4h3m-6-4h.01M9 16h.01"></path>
            </svg>
        )
    },
    {
        // ADDED ICON FOR GROUP TITLE
        title: 'Content Mgmt',
        icon: <DocumentTextIcon className="w-5 h-5" />, 
        items: [
            {
                name: 'Sliders',
                href: route('admin.sliders.index'),
                icon: (
                    <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path strokeLinecap="round" strokeLinejoin="round" strokeWidth="2" d="M7 4v16M17 4v16M3 8h4m10 0h4M3 12h18M3 16h4m10 0h4M4 20h16a1 1 0 001-1V5a1 1 0 00-1-1H4a1 1 0 00-1 1v14a1 1 0 001 1z" />
                    </svg>
                ),
                activeMatch: 'admin.sliders.*',
            },
            {
                name: 'Gallery',
                href: route('admin.gallery.index'),
                icon: (
                    <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path strokeLinecap="round" strokeLinejoin="round" strokeWidth="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z" />
                    </svg>
                ),
                activeMatch: 'admin.gallery.*',
            },
            {
                name: 'Posts',
                href: route('admin.posts.index'),
                icon: (
                    <DocumentTextIcon className="w-5 h-5" />
                ),
                activeMatch: 'admin.posts.*',
            },
        ],
    },
    {
        // ADDED ICON FOR GROUP TITLE
        title: 'Settings',
        icon: <Cog6ToothIcon className="w-5 h-5" />, // New icon for the group
        items: [
            {
                name: 'General Settings',
                href: route('admin.settings.edit', { setting: 1 }),
                icon: (
                    <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path strokeLinecap="round" strokeLinejoin="round" strokeWidth="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z" />
                        <path strokeLinecap="round" strokeLinejoin="round" strokeWidth="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                    </svg>
                ),
                activeMatch: 'admin.settings.edit',
            },
            {
                name: 'Core Values',
                href: route('admin.settings.core-values.index'),
                icon: (
                    <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path strokeLinecap="round" strokeLinejoin="round" strokeWidth="2" d="M13 10V3L4 14h7v7l9-11h-7z" />
                    </svg>
                ),
                activeMatch: 'admin.settings.core-values.*',
            },
            {
                name: 'Payment Settings',
                href: route('admin.payment-settings.edit'),
                icon: (
                    <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path strokeLinecap="round" strokeLinejoin="round" strokeWidth="2" d="M3 10h18M7 15h10m-9 4h8m-10 4h12a2 2 0 002-2V6a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                    </svg>
                ),
                activeMatch: 'admin.payment-settings.*',
            },
        ],
    },
];

const userNavigationData = [
    {
        name: 'Dashboard',
        href: route('user.dashboard'),
        icon: (
            <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path strokeLinecap="round" strokeLinejoin="round" strokeWidth="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6" />
            </svg>
        ),
        activeMatch: 'user.dashboard',
    },
    {
        name: 'Notifications',
        href: route('user.notifications.index'),
        icon: (
            <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                <path strokeLinecap="round" strokeLinejoin="round" strokeWidth="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"></path>
            </svg>
        ),
        activeMatch: 'user.notifications.*',
    },
    {
        name: 'My Bookings',
        href: route('user.bookings.index'),
        icon: (
            <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                <path strokeLinecap="round" strokeLinejoin="round" strokeWidth="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-3 7h3m-3 4h3m-6-4h.01M9 16h.01"></path>
            </svg>
        ),
        activeMatch: 'user.bookings.*',
    },
    {
        name: 'My Tickets',
        href: route('user.tickets.index'),
        icon: (
            <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                <path strokeLinecap="round" strokeLinejoin="round" strokeWidth="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-3 7h3m-3 4h3m-6-4h.01M9 16h.01"></path>
            </svg>
        ),
        activeMatch: 'user.tickets.*',
    },
    {
        name: 'My Orders',
        href: route('user.orders.index'),
        icon: (
            <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                <path strokeLinecap="round" strokeLinejoin="round" strokeWidth="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-3 7h3m-3 4h3m-6-4h.01M9 16h.01"></path>
            </svg>
        ),
        activeMatch: 'user.orders.*',
    },
    {
        name: 'My School Services',
        href: route('user.school-services.index'),
        icon: (
            <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                <path strokeLinecap="round" strokeLinejoin="round" strokeWidth="2" d="M12 6.253v13m0-13C10.832 5.477 9.206 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.832 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.794 5 16.5 5s3.332.477 4.5 1.253v13C19.832 18.477 18.168 18 16.5 18s-3.332.477-4.5 1.253"></path>
            </svg>
        ),
        activeMatch: 'user.school-service-bookings.*',
    },
];

// --- Sub-Component for Recursive Nav Items (Kept as is) ---
const NavItem = ({ item, isChild = false }) => {
    const [isExpanded, setIsExpanded] = useState(() => {
        // Initialize expanded state based on whether a child item is currently active
        if (item.items) {
            return item.items.some(subItem => {
                const regex = new RegExp('^' + subItem.activeMatch.replace('*', '.*'));
                // @ts-ignore
                return regex.test(route().current());
            });
        }
        return false;
    });

    const hasChildren = item.items && item.items.length > 0;

    const isActive = (match) => {
        // @ts-ignore
        if (!match) return false;
        const regex = new RegExp('^' + match.replace('*', '.*'));
        // @ts-ignore
        return regex.test(route().current());
    };

    if (hasChildren) {
        // Determine if the parent group is currently active (if any child is active)
        const isGroupActive = item.items.some(subItem => isActive(subItem.activeMatch));

        return (
            <div>
                <button
                    onClick={() => setIsExpanded(!isExpanded)}
                    className={`group w-full flex items-center justify-between px-4 py-3 text-sm font-medium rounded-lg transition-all duration-200 ${
                        isGroupActive
                            ? 'bg-slate-700 text-white'
                            : 'text-slate-300 hover:text-white hover:bg-slate-700/50'
                    }`}
                >
                    <span className="flex items-center">
                        {/* RENDER THE PARENT GROUP ICON HERE */}
                        <span className="mr-3 text-slate-400 group-hover:text-white transition-colors duration-200">
                            {item.icon} 
                        </span>
                        <span className="tracking-wide">{item.title}</span>
                    </span>
                    <ChevronRightIcon
                        className={`w-4 h-4 text-slate-400 transition-transform duration-200 ${isExpanded ? 'rotate-90' : ''}`}
                    />
                </button>
                <div
                    // Using `max-h-0` for Tailwind's transition effect
                    className={`overflow-hidden transition-all duration-300 ease-in-out ${isExpanded ? 'max-h-96 opacity-100' : 'max-h-0 opacity-0'}`}
                >
                    <div className="mt-1 ml-4 space-y-1">
                        {/* We don't need the 'isExpanded &&' check since the max-h transition handles visibility */}
                        {item.items.map((subItem) => (
                            <NavItem key={subItem.name} item={subItem} isChild={true} />
                        ))}
                    </div>
                </div>
            </div>
        );
    }

    return (
        <NavLink
            key={item.name}
            href={item.href}
            active={isActive(item.activeMatch)}
            className={({ active }) =>
                `group flex items-center px-4 py-3 text-sm font-medium rounded-lg transition-all duration-200 ${
                    active
                        ? 'bg-slate-700 text-white'
                        : 'text-slate-300 hover:text-white hover:bg-slate-700/50'
                } ${isChild ? 'pl-10' : ''}`
            }
        >
            <span className={`mr-3 transition-colors duration-200 ${
                isActive(item.activeMatch) ? 'text-green-400' : 'text-slate-400 group-hover:text-white'
            }`}>
                {item.icon}
            </span>
            <span className="tracking-wide flex-1">{item.name}</span>
            {item.hasNotification && (
                <span className="flex h-2 w-2">
                    <span className="animate-ping absolute inline-flex h-2 w-2 rounded-full bg-red-400 opacity-75"></span>
                    <span className="relative inline-flex rounded-full h-2 w-2 bg-red-500"></span>
                </span>
            )}
        </NavLink>
    );
};


// --- Updated Main Navigation Component with New Background and Overlay ---
export default function Navigation({ closeNavigation }) { 
    const { auth } = usePage().props;
    const user = auth.user;
    const hasUnreadNotifications = auth.unreadNotifications.length > 0;

    let currentNavigationData;

    if (user && user.role >= 500) { // System Admin
        currentNavigationData = adminNavigationData;
    } else if (user && user.role === 200) { // Doctor
        const assignedBookingsLink = {
            name: 'Assigned Bookings',
            href: route('user.doctors.assigned-bookings'),
            activeMatch: 'user.doctors.assigned-bookings',
            icon: (
                <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                    <path strokeLinecap="round" strokeLinejoin="round" strokeWidth="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-3 7h3m-3 4h3m-6-4h.01M9 16h.01"></path>
                </svg>
            ),
            hasNotification: hasUnreadNotifications,
        };
        currentNavigationData = [...userNavigationData, assignedBookingsLink];
    } else if (user && user.role >= 100 && user.role < 200) { // Regular User
        currentNavigationData = userNavigationData.map(item => {
            if (item.name === 'Notifications') {
                return { ...item, hasNotification: hasUnreadNotifications };
            }
            return item;
        });
    } else { // Other Admin roles (e.g., < 100)
        currentNavigationData = adminNavigationData;
    }


    return (
        <div className="flex flex-col h-full relative overflow-hidden">
            
            <div 
                className="absolute inset-0 z-0" 
                style={{ 
                    backgroundImage: `url('https://images.unsplash.com/photo-1549497538-303791108f95?q=80&w=1974&auto=format&fit=crop&ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D')`, 
                    backgroundSize: 'cover', 
                    backgroundPosition: 'center',
                }}
            >
                <div className="absolute inset-0 bg-slate-900/90"></div>
            </div>

            <div className="relative flex flex-col h-full z-10 bg-transparent">
                
                <div className="flex items-center justify-between px-6 py-6 border-b border-slate-700/50">
                    
                    <Link href={route('home')} className="flex items-center space-x-3 group">
                        <div className="flex-shrink-0 p-2 bg-gradient-to-br from-green-500 to-indigo-700 rounded-lg shadow-lg group-hover:shadow-indigo-500/25 transition-all duration-300">
                            <svg className="h-6 w-6 text-white" fill="currentColor" viewBox="0 0 20 20">
                                <path fillRule="evenodd" d="M5.05 4.05a7 7 0 119.9 9.9L10 18.9l-4.95-4.95a7 7 0 010-9.9zM10 11a2 2 0 100-4 2 2 0 000 4z" clipRule="evenodd" />
                            </svg>
                        </div>
                        <div>
                            <h1 className="text-xl font-bold text-white">
                                <span className="text-green-400">Promise</span>
                                <span className="font-light text-slate-200">Palm</span>
                            </h1>
                        </div>
                    </Link>

                    <motion.button
                        onClick={closeNavigation} 
                        className="lg:hidden p-2 rounded-lg text-slate-400 hover:text-white hover:bg-slate-700/50 transition-colors duration-200"
                        whileHover={{ scale: 1.1 }}
                        whileTap={{ scale: 0.9 }}
                        aria-label="Close navigation menu"
                    >
                        <XMarkIcon className="w-6 h-6" />
                    </motion.button>
                </div>

                <nav className="flex-1 px-4 py-6 space-y-2 overflow-y-auto">
                    {currentNavigationData.map((item) => (
                        <NavItem key={item.title || item.name} item={item} />
                    ))}
                </nav>

                <div className="px-4 py-4 border-t border-slate-700/50">
                    <Dropdown>
                        <Dropdown.Trigger>
                            <div className="flex items-center w-full p-3 rounded-lg hover:bg-slate-700/50 transition-colors duration-200 cursor-pointer">
                                <div className="flex-shrink-0">
                                    <div className="h-10 w-10 rounded-full bg-gradient-to-br from-green-500 to-indigo-700 flex items-center justify-center text-white font-semibold shadow-lg">
                                        {user?.name?.charAt(0).toUpperCase() || 'A'}
                                    </div>
                                </div>
                                <div className="ml-3 flex-1 min-w-0">
                                    <div className="text-sm font-medium text-white truncate">{user?.name || 'Admin User'}</div>
                                    <div className="text-xs text-slate-400 truncate">{user?.email || 'admin@example.com'}</div>
                                </div>
                                <ChevronDownIcon className="w-4 h-4 text-slate-400" />
                            </div>
                        </Dropdown.Trigger>
                        <Dropdown.Content contentClasses="bg-slate-800 border border-slate-700/50 mt-2" width="w-56">
                            <div className="px-4 py-3 border-b border-slate-700/50">
                                <p className="text-sm font-medium text-white">Signed in as</p>
                                <p className="text-sm text-slate-400 truncate">{user?.email}</p>
                            </div>
                            <div className="py-1">
                                <Dropdown.Link href={route('profile.edit') || '#'} className="text-slate-300 hover:bg-slate-700 hover:text-white">
                                    Your Profile
                                </Dropdown.Link>
                                <Dropdown.Link href={route('logout')} method="post" as="button" className="text-slate-300 hover:bg-slate-700 hover:text-white">
                                    Sign Out
                                </Dropdown.Link>
                            </div>
                        </Dropdown.Content>
                    </Dropdown>
                </div>
            </div>
        </div>
    );
}