import React from 'react';
import AdminLayout from '@/Layouts/AdminLayout';
import { Head } from '@inertiajs/react';

export default function Show({ auth, product }) {
    return (
        <AdminLayout
            user={auth.user}
            header={<h2 className="font-semibold text-xl text-gray-800 leading-tight">Product Details</h2>}
        >
            <Head title="Product Details" />

            <div className="py-12">
                <div className="max-w-7xl mx-auto sm:px-6 lg:px-8">
                    <div className="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                        <div className="p-6 text-gray-900">
                            <h3 className="text-lg font-medium text-gray-900 mb-4">{product.name}</h3>

                            <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div>
                                    <p className="text-sm text-gray-600"><strong>Description:</strong> {product.description}</p>
                                    <p className="text-sm text-gray-600"><strong>Price:</strong> ${product.price}</p>
                                    <p className="text-sm text-gray-600"><strong>Stock:</strong> {product.stock}</p>
                                    <p className="text-sm text-gray-600"><strong>Category:</strong> {product.category}</p>
                                </div>
                                <div>
                                    {product.images && product.images.length > 0 && (
                                        <div className="flex flex-wrap gap-2">
                                            {product.images.map((image, index) => (
                                                <img key={index} src={image} alt="Product Image" className="h-32 w-32 object-cover rounded-md" />
                                            ))}
                                        </div>
                                    )}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </AdminLayout>
    );
}
