import React from 'react';
import { Link, Head, useForm } from '@inertiajs/react';

export default function Edit({ schoolService }) {
    const { data, setData, put, processing, errors } = useForm({
        name: schoolService.name || '',
        description: schoolService.description || '',
        type: schoolService.type || 'free',
    });

    function handleSubmit(e) {
        e.preventDefault();
        put(route('admin.school-services.update', schoolService.id));
    }

    return (
        <div className="min-h-screen bg-gray-100 p-8">
            <Head title={`Edit School Service - ${schoolService.name}`} />

            <div className="max-w-2xl mx-auto">
                <div className="flex justify-between items-center mb-6">
                    <h1 className="text-3xl font-bold text-gray-800">Edit School Service</h1>
                    <Link
                        href={route('admin.school-services.index')}
                        className="px-6 py-2 text-white bg-gray-500 rounded-md hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-gray-500 focus:ring-opacity-50 transition-all"
                    >
                        Back
                    </Link>
                </div>

                <div className="bg-white shadow-md rounded-lg p-8">
                    <form onSubmit={handleSubmit} className="space-y-6">
                        <div>
                            <label htmlFor="name" className="block text-sm font-medium text-gray-700">Name</label>
                            <input
                                type="text"
                                id="name"
                                value={data.name}
                                onChange={(e) => setData('name', e.target.value)}
                                className="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm"
                            />
                            {errors.name && <div className="text-red-600 text-sm mt-1">{errors.name}</div>}
                        </div>

                        <div>
                            <label htmlFor="description" className="block text-sm font-medium text-gray-700">Description</label>
                            <textarea
                                id="description"
                                value={data.description}
                                onChange={(e) => setData('description', e.target.value)}
                                rows="4"
                                className="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm"
                            ></textarea>
                            {errors.description && <div className="text-red-600 text-sm mt-1">{errors.description}</div>}
                        </div>

                        <div>
                            <label htmlFor="type" className="block text-sm font-medium text-gray-700">Type</label>
                            <select
                                id="type"
                                value={data.type}
                                onChange={(e) => setData('type', e.target.value)}
                                className="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm"
                            >
                                <option value="free">Free</option>
                                <option value="premium">Premium</option>
                            </select>
                            {errors.type && <div className="text-red-600 text-sm mt-1">{errors.type}</div>}
                        </div>

                        <div className="flex items-center justify-end">
                            <button
                                type="submit"
                                disabled={processing}
                                className="px-6 py-2 text-white bg-indigo-600 rounded-md hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-opacity-50 transition-all disabled:bg-gray-400"
                            >
                                {processing ? 'Saving...' : 'Update School Service'}
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    );
}
