import React from 'react';
import { Head } from '@inertiajs/react';
import Navbar from '@/Components/Navbar';
import Footer from '@/Components/Footer';
import { motion } from 'framer-motion';

const containerVariants = {
    hidden: { opacity: 0 },
    visible: {
        opacity: 1,
        transition: {
            staggerChildren: 0.15,
            delayChildren: 0.3
        }
    }
};

const itemVariants = {
    hidden: { y: 20, opacity: 0 },
    visible: { y: 0, opacity: 1, transition: { duration: 0.5, ease: "easeOut" } }
};

export default function Gallery({ setting, galleries }) {
    return (
        <div className="min-h-screen bg-gray-100 font-sans antialiased">
            <Head title="Our Gallery" />
            <Navbar setting={setting} />

            <div className="relative bg-gradient-to-r from-blue-600 to-indigo-700 py-20 text-white">
                <div className="container mx-auto px-6 text-center">
                    <h1 className="text-4xl font-bold mb-2">Our Gallery</h1>
                    <p className="text-lg opacity-90">A visual journey through our work and achievements.</p>
                </div>
            </div>

            <section className="py-12">
                <div className="container mx-auto px-6">
                    {galleries.length > 0 ? (
                        <motion.div
                            className="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-6"
                            variants={containerVariants}
                            initial="hidden"
                            whileInView="visible"
                            viewport={{ once: true, amount: 0.2 }}
                        >
                            {galleries.map((item) => (
                                <motion.div
                                    key={item.id}
                                    className="bg-white rounded-lg shadow-md overflow-hidden group"
                                    variants={itemVariants}
                                    whileHover={{ scale: 1.03 }}
                                >
                                    <a href={item.url || item.image_url} target="_blank" rel="noopener noreferrer" className="block relative overflow-hidden">
                                        <img src={item.image_url} alt={item.title} className="w-full object-contain transform group-hover:scale-105 transition-transform duration-300" />
                                        {item.url && (
                                            <div className="absolute inset-0 bg-black bg-opacity-50 flex items-center justify-center opacity-0 group-hover:opacity-100 transition-opacity duration-300">
                                                <span className="text-white text-lg font-semibold">View Project</span>
                                            </div>
                                        )}
                                    </a>
                                    <div className="p-4">
                                        <h2 className="text-xl font-semibold text-gray-800 mb-1">{item.title}</h2>
                                        <p className="text-gray-600 text-sm">{item.description}</p>
                                    </div>
                                </motion.div>
                            ))}
                        </motion.div>
                    ) : (
                        <p className="text-center text-gray-600">No gallery items found.</p>
                    )}
                </div>
            </section>

            <Footer setting={setting} />
        </div>
    );
}
