import React from 'react';
import HomeLayout from '@/Layouts/HomeLayout';
import { Head } from '@inertiajs/react';

export default function PaymentSuccess() {
    return (
        <HomeLayout>
            <Head title="Payment Success" />
            <div className="flex items-center justify-center min-h-screen bg-gray-100">
                <div className="bg-white p-8 rounded-lg shadow-lg text-center">
                    <svg className="mx-auto h-16 w-16 text-green-500" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                        <path strokeLinecap="round" strokeLinejoin="round" strokeWidth="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                    <h1 className="text-3xl font-bold text-gray-800 mt-4">Payment Successful!</h1>
                    <p className="text-gray-600 mt-2">Your transaction was completed successfully. Thank you for your purchase!</p>
                    <a href="/" className="mt-6 inline-block bg-blue-500 hover:bg-blue-600 text-white font-bold py-2 px-4 rounded">
                        Go to Homepage
                    </a>
                </div>
            </div>
        </HomeLayout>
    );
}