import React from 'react';
import { Head } from '@inertiajs/react';
import HeroSlider from '@/Components/HeroSlider';
import AboutSection from '@/Components/AboutSection';
import ServicesSection from '@/Components/ServicesSection';
import PortfolioSection from '@/Components/PortfolicSection';
import TeamSection from '@/Components/TeamSection';
import ContactSection from '@/Components/ContactSection';
import Footer from '@/Components/Footer';
import HomeLayout from '@/Layouts/HomeLayout';
import EventsSection from '@/Components/EventsSection';
import ProductsSection from '@/Components/ProductsSection';
import PregnancySchoolsSection from '@/Components/SchoolSection';

export default function Welcome({ sliders, services, portfolios, teams, setting, events, products, schools }) {
    console.log(setting)
    return (
        <HomeLayout>
            <Head title={`Welcome to `} />

            {/* Hero Section with Slider */}
            <HeroSlider sliders={sliders} />

            {/* About Us Section */}
            <AboutSection setting={setting} />

            <ServicesSection services={services} />

            <EventsSection events={events} />
            {/* Team Section */}
            <ProductsSection products={products} />

            <PregnancySchoolsSection schools={schools}/>

            {/* Contact Us Section */}
            <ContactSection setting={setting} />
        </HomeLayout>
    );
}
