<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Booking Confirmation</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body {
            background-color: #f5f5f5;
            padding: 20px;
            color: #333;
        }
        
        .container {
            max-width: 600px;
            margin: 0 auto;
            background-color: white;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
        }
        
        .header {
            background-color: #2E7D32;
            padding: 30px 20px;
            text-align: center;
            color: white;
        }
        
        .header h1 {
            font-size: 28px;
            font-weight: 600;
            margin-bottom: 5px;
        }
        
        .header p {
            font-size: 16px;
            opacity: 0.9;
        }
        
        .content {
            padding: 30px;
        }
        
        .greeting {
            font-size: 18px;
            margin-bottom: 20px;
            color: #333;
        }
        
        .message {
            margin-bottom: 25px;
            line-height: 1.5;
        }
        
        .booking-details {
            background-color: #f9f9f9;
            border-left: 4px solid #2E7D32;
            padding: 20px;
            border-radius: 5px;
            margin-bottom: 30px;
        }
        
        .booking-details h3 {
            font-size: 18px;
            margin-bottom: 15px;
            color: #2E7D32;
        }
        
        .detail-item {
            display: flex;
            margin-bottom: 12px;
            padding-bottom: 12px;
            border-bottom: 1px solid #e0e0e0;
        }
        
        .detail-item:last-child {
            border-bottom: none;
            margin-bottom: 0;
            padding-bottom: 0;
        }
        
        .detail-label {
            font-weight: 600;
            width: 150px;
            color: #333;
        }
        
        .detail-value {
            flex: 1;
            color: #555;
        }
        
        .cta-button {
            display: inline-block;
            background-color: #2E7D32;
            color: #FFFFFF !important; /* Explicitly set to white with !important */
            padding: 12px 30px;
            text-decoration: none;
            border-radius: 5px;
            font-weight: 600;
            margin: 20px 0;
            transition: background-color 0.3s;
            text-align: center;
        }
        
        .cta-button:hover {
            background-color: #1B5E20;
        }
        
        .footer {
            background-color: #f5f5f5;
            padding: 20px;
            text-align: center;
            border-top: 1px solid #e0e0e0;
        }
        
        .footer p {
            font-size: 14px;
            color: #666;
        }
        
        .icon {
            display: inline-block;
            width: 20px;
            height: 20px;
            margin-right: 8px;
            vertical-align: middle;
        }
        
        .status-badge {
            display: inline-block;
            padding: 4px 10px;
            border-radius: 20px;
            font-size: 14px;
            font-weight: 600;
        }
        
        .status-confirmed {
            background-color: #e8f5e9;
            color: #2E7D32;
        }
        
        @media only screen and (max-width: 600px) {
            .container {
                width: 100%;
            }
            
            .detail-item {
                flex-direction: column;
            }
            
            .detail-label {
                width: 100%;
                margin-bottom: 5px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>Booking Confirmation</h1>
            <p>Your booking has been successfully confirmed</p>
        </div>
        
        <div class="content">
            <p class="greeting">Dear User,</p>
            <p class="message">Thank you for your booking! We're pleased to confirm that your reservation has been successfully processed. Here are your booking details:</p>
            
            <div class="booking-details">
                <h3>Booking Information</h3>
                
                <div class="detail-item">
                    <div class="detail-label">
                        <svg class="icon" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                        </svg>
                        Booking ID:
                    </div>
                    <div class="detail-value">{{ $booking->id }}</div>
                </div>
                
                <div class="detail-item">
                    <div class="detail-label">
                        <svg class="icon" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-12a1 1 0 10-2 0v4a1 1 0 00.293.707l2.828 2.829a1 1 0 101.415-1.415L11 9.586V6z" clip-rule="evenodd"></path>
                        </svg>
                        Status:
                    </div>
                    <div class="detail-value">
                        <span class="status-badge status-confirmed">{{ $booking->status }}</span>
                    </div>
                </div>
                
                <div class="detail-item">
                    <div class="detail-label">
                        <svg class="icon" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M8.433 7.418c.155-.103.346-.196.567-.267v1.698a2.305 2.305 0 01-.567-.267C8.07 8.34 8 8.114 8 8c0-.114.07-.34.433-.582zM11 12.849v-1.698c.22.071.412.164.567.267.364.243.433.468.433.582 0 .114-.07.34-.433.582a2.305 2.305 0 01-.567.267z"></path>
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-13a1 1 0 10-2 0v.092a4.535 4.535 0 00-1.676.662C6.602 6.234 6 7.009 6 8c0 .99.602 1.765 1.324 2.246.48.32 1.054.545 1.676.662v1.941c-.391-.127-.68-.317-.843-.504a1 1 0 10-1.51 1.31c.562.649 1.413 1.076 2.353 1.253V15a1 1 0 102 0v-.092a4.535 4.535 0 001.676-.662C13.398 13.766 14 12.991 14 12c0-.99-.602-1.765-1.324-2.246A4.535 4.535 0 0011 9.092V7.151c.391.127.68.317.843.504a1 1 0 101.511-1.31c-.563-.649-1.413-1.076-2.354-1.253V5z" clip-rule="evenodd"></path>
                        </svg>
                        Price:
                    </div>
                    <div class="detail-value">GH₵{{ number_format($booking->price, 2) }}</div>
                </div>
                
                <div class="detail-item">
                    <div class="detail-label">
                        <svg class="icon" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M6 2a1 1 0 00-1 1v1H4a2 2 0 00-2 2v10a2 2 0 002 2h12a2 2 0 002-2V6a2 2 0 00-2-2h-1V3a1 1 0 10-2 0v1H7V3a1 1 0 00-1-1zm0 5a1 1 0 000 2h8a1 1 0 100-2H6z" clip-rule="evenodd"></path>
                        </svg>
                        Booking Date:
                    </div>
                    <div class="detail-value">{{ $booking->booking_date }}</div>
                </div>
            </div>
            
            <p style="margin-bottom: 10px;">You can view your complete booking details by clicking the button below:</p>
            <a href="{{ url('/user/bookings/' . $booking->id) }}" class="cta-button" style="color: #FFFFFF !important;">View Booking Details</a>
            
            <p style="margin-top: 30px; font-style: italic;">Thank you for choosing our service! We look forward to serving you.</p>
        </div>
        
        <div class="footer">
            <p>&copy; {{ date('Y') }} PromiseBalm All rights reserved.</p>
            <p style="margin-top: 5px;">This is an automated message, please do not reply to this email.</p>
        </div>
    </div>
</body>
</html>