<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>New Service Booking Assigned</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: #333333;
            background-color: #f0f4f0;
            margin: 0;
            padding: 0;
        }
        .container {
            max-width: 600px;
            margin: 20px auto;
            background-color: #ffffff;
            padding: 0;
            border-radius: 10px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
            overflow: hidden;
        }
        .header {
            background: linear-gradient(135deg, #1a4d2e, #2d6a4f);
            color: #ffffff;
            padding: 25px 30px;
            text-align: center;
            position: relative;
        }
        .header h2 {
            margin: 0;
            font-size: 24px;
            font-weight: 600;
        }
        .header::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 100%;
            height: 4px;
            background: linear-gradient(90deg, #40916c, #52b788);
        }
        .content {
            padding: 30px;
        }
        .greeting {
            font-size: 18px;
            margin-bottom: 15px;
            color: #1a4d2e;
            font-weight: 600;
        }
        .message {
            margin-bottom: 25px;
            color: #444;
        }
        .details {
            background-color: #f1f8f4;
            border-left: 4px solid #2d6a4f;
            padding: 20px;
            margin: 25px 0;
            border-radius: 0 8px 8px 0;
        }
        .details p {
            margin: 10px 0;
            display: flex;
            align-items: center;
        }
        .details strong {
            color: #1a4d2e;
            min-width: 80px;
            font-weight: 600;
        }
        .button-container {
            text-align: center;
            margin: 30px 0;
        }
        .button {
            display: inline-block;
            background: linear-gradient(135deg, #2d6a4f, #40916c);
            color: #ffffff !important; /* Explicitly set to white with !important */
            padding: 12px 25px;
            text-decoration: none !important; /* Ensure link color doesn't override */
            border-radius: 50px;
            font-weight: 600;
            transition: all 0.3s ease;
            box-shadow: 0 4px 8px rgba(45, 106, 79, 0.3);
        }
        .button:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 12px rgba(45, 106, 79, 0.4);
        }
        .footer {
            text-align: center;
            margin: 0;
            font-size: 14px;
            color: #666;
            background-color: #f1f8f4;
            padding: 20px;
            border-top: 1px solid #e0e9e4;
        }
        .footer p {
            margin: 0;
        }
        .icon {
            display: inline-block;
            width: 20px;
            height: 20px;
            margin-right: 8px;
            vertical-align: middle;
            background-color: #2d6a4f;
            border-radius: 50%;
            position: relative;
        }
        .icon::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            width: 10px;
            height: 10px;
            background-color: white;
            border-radius: 50%;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h2>New Service Booking Assigned</h2>
        </div>
        <div class="content">
            <p class="greeting">Hello {{ $doctor->name }},</p>
            <p class="message">A new service booking has been assigned to you. Please review the details below:</p>
            
            <div class="details">
                <p><span class="icon"></span><strong>Service:</strong> {{ $booking->bookable->title ?? 'N/A' }}</p>
                <p><span class="icon"></span><strong>Patient:</strong> {{ $booking->user->name ?? 'N/A' }}</p>
                <p><span class="icon"></span><strong>Date:</strong> {{ $booking->booking_date ? \Carbon\Carbon::parse($booking->booking_date)->format('M d, Y') : 'N/A' }}</p>
                <p><span class="icon"></span><strong>Time:</strong> {{ $booking->serviceBookingDetail->booking_time ?? 'N/A' }}</p>
            </div>

            <p class="message">Please review the details and update the approval status at your earliest convenience.</p>
            
            <div class="button-container">
                <a href="{{ url(route('user.doctors.assigned-bookings')) }}" class="button">View Assigned Booking</a>
            </div>
            
            <p class="message">Thank you for your dedication!</p>
        </div>
        <div class="footer">
            <p>&copy; {{ date('Y') }} PromisePalm. All rights reserved.</p>
        </div>
    </div>
</body>
</html>