<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="en-GB">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>{{ $mailData['title'] ?? 'Oshelter' }}</title>
    <!--[if mso]>
    <style type="text/css">
        body, table, td {font-family: Georgia, serif !important;}
    </style>
    <![endif]-->
</head>
<body style="margin: 0; padding: 0; background: linear-gradient(135deg, #f5e6ff 0%, #e6f0ff 50%, #ffe6f0 100%); font-family: Georgia, 'Times New Roman', serif; color: #333333; font-size: 16px; line-height: 1.7;">
    <center>
        <table role="presentation" width="100%" cellspacing="0" cellpadding="0" border="0">
            <tr>
                <td align="center" style="padding: 30px 0;">
                    <table role="presentation" width="100%" cellspacing="0" cellpadding="0" border="0" align="center" style="max-width: 600px; background-color: #ffffff; border-radius: 16px; overflow: hidden; box-shadow: 0 10px 30px rgba(147, 51, 234, 0.15); border: 1px solid rgba(147, 51, 234, 0.1);">
                        
                        <!-- Elegant Header with Decorative Elements -->
                        <tr>
                            <td style="padding: 0; position: relative;">
                                <div style="height: 4px; background: linear-gradient(90deg, #d946ef, #a855f7, #ec4899);"></div>
                                <table role="presentation" width="100%" cellspacing="0" cellpadding="0" border="0">
                                    <tr>
                                        <td align="center" style="padding: 0; background: linear-gradient(135deg, rgba(219, 39, 119, 0.05), rgba(147, 51, 234, 0.05), rgba(59, 130, 246, 0.05)); position: relative;">
                                            <table role="presentation" width="100%" cellspacing="0" cellpadding="0" border="0">
                                                <tr>
                                                    <td align="center" style="padding: 40px 20px 30px;">
                                                        <div style="position: relative; display: inline-block;">
                                                            <div style="position: absolute; top: -10px; left: -10px; right: -10px; bottom: -10px; background: linear-gradient(45deg, rgba(219, 39, 119, 0.2), rgba(147, 51, 234, 0.2)); border-radius: 50%; filter: blur(15px); z-index: 0;"></div>
                                                            <img src="https://imaging.oshelter.com/logo.png" alt="OShelter Logo" style="width: 160px; height: auto; border: 0; display: block; max-width: 100%; position: relative; z-index: 1;" />
                                                        </div>
                                                        <h1 style="margin: 20px 0 0; color: #581c87; font-size: 28px; font-weight: 300; letter-spacing: 1px; font-style: italic;">{{ $mailData['subject'] ?? 'Welcome to OShelter' }}</h1>
                                                    </td>
                                                </tr>
                                            </table>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>

                        <!-- Elegant Content Section -->
                        <tr>
                            <td style="padding: 40px 30px; color: #4a5568; position: relative;">
                                <div style="position: absolute; top: 0; left: 30px; right: 30px; height: 1px; background: linear-gradient(90deg, transparent, rgba(147, 51, 234, 0.3), transparent);"></div>
                                
                                <h2 style="margin: 20px 0 20px; color: #581c87; font-size: 24px; font-weight: 400; text-align: center; position: relative;">
                                    <span style="position: relative; z-index: 1;">Hello {{ $mailData['name'] ?? 'there' }},</span>
                                </h2>
                                
                                <p style="margin: 0 0 20px; text-align: center; font-size: 17px; line-height: 1.8;">
                                    Thank you for your interest in <span style="color: #a855f7; font-weight: 600;">OShelter</span>. We're delighted to welcome you to our exclusive community!
                                </p>
                                
                                <div style="text-align: center; margin: 30px 0;">
                                    <div style="display: inline-block; padding: 20px; background: linear-gradient(135deg, rgba(219, 39, 119, 0.03), rgba(147, 51, 234, 0.03)); border-radius: 12px; border: 1px solid rgba(147, 51, 234, 0.1);">
                                        <p style="margin: 0; font-style: italic; color: #6b46c1; font-size: 16px;">
                                            "{{ $mailData['message'] ?? 'Our platform offers comprehensive solutions for shelter management, helping communities organize and respond effectively to housing needs.' }}"
                                        </p>
                                    </div>
                                </div>
                                
                                <table role="presentation" cellspacing="0" cellpadding="0" border="0" style="margin: 30px auto;">
                                    <tr>
                                        <td align="center" style="border-radius: 50px; background: linear-gradient(135deg, #d946ef, #a855f7); box-shadow: 0 4px 15px rgba(147, 51, 234, 0.3); position: relative; overflow: hidden;">
                                            <div style="position: absolute; top: 0; left: -100%; width: 100%; height: 100%; background: linear-gradient(90deg, transparent, rgba(255,255,255,0.3), transparent); animation: shimmer 2s infinite;"></div>
                                            <a href="{{ $mailData['button_url'] ?? '#' }}" target="_blank" style="font-size: 16px; font-weight: 500; color: #ffffff; text-decoration: none; display: inline-block; padding: 14px 40px; border-radius: 50px; position: relative; z-index: 1; letter-spacing: 0.5px;">{{ $mailData['button_text'] ?? 'Get Started' }}</a>
                                        </td>
                                    </tr>
                                </table>
                                
                                <p style="margin: 30px 0 20px; text-align: center; font-size: 15px;">
                                    If you have any questions, feel free to contact our support team at <a href="mailto:support@oshelter.com" style="color: #a855f7; text-decoration: none; border-bottom: 1px solid rgba(168, 85, 247, 0.3); padding-bottom: 1px;">support@oshelter.com</a>.
                                </p>
                                
                                <div style="text-align: center; margin-top: 30px; padding-top: 20px; border-top: 1px solid rgba(147, 51, 234, 0.1);">
                                    <p style="margin: 0; font-style: italic; color: #6b46c1; font-size: 16px;">With warm regards,</p>
                                    <p style="margin: 5px 0 0; color: #581c87; font-weight: 500;">The OShelter Team</p>
                                </div>
                            </td>
                        </tr>

                        <!-- Elegant Features Section -->
                        <tr>
                            <td style="padding: 0 30px 30px; background: linear-gradient(135deg, rgba(219, 39, 119, 0.02), rgba(147, 51, 234, 0.02)); position: relative;">
                                <div style="position: absolute; top: 0; left: 30px; right: 30px; height: 1px; background: linear-gradient(90deg, transparent, rgba(147, 51, 234, 0.2), transparent);"></div>
                                
                                <table role="presentation" width="100%" cellspacing="0" cellpadding="0" border="0">
                                    <tr>
                                        <td style="padding: 20px 0 15px;">
                                            <h3 style="margin: 0; color: #581c87; font-size: 18px; text-align: center; font-weight: 400; letter-spacing: 1px; position: relative;">
                                                <span style="position: relative; z-index: 1;">✨ Why Choose OShelter? ✨</span>
                                            </h3>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <table role="presentation" width="100%" cellspacing="0" cellpadding="0" border="0">
                                                <tr>
                                                    <td style="padding: 12px 8px; width: 33.33%;" align="center">
                                                        <div style="display: inline-block; padding: 12px; background: linear-gradient(135deg, rgba(219, 39, 119, 0.1), rgba(147, 51, 234, 0.1)); border-radius: 50%; margin-bottom: 8px;">
                                                            <img src="https://imaging.oshelter.com/feature1.png" alt="Easy Management" width="32" height="32" style="display: block;" />
                                                        </div>
                                                        <h4 style="margin: 0 0 4px; font-size: 14px; color: #581c87; font-weight: 500;">Easy Management</h4>
                                                        <p style="margin: 0; font-size: 12px; color: #6b7280;">Streamlined operations</p>
                                                    </td>
                                                    <td style="padding: 12px 8px; width: 33.33%;" align="center">
                                                        <div style="display: inline-block; padding: 12px; background: linear-gradient(135deg, rgba(147, 51, 234, 0.1), rgba(59, 130, 246, 0.1)); border-radius: 50%; margin-bottom: 8px;">
                                                            <img src="https://imaging.oshelter.com/feature2.png" alt="Real-time Updates" width="32" height="32" style="display: block;" />
                                                        </div>
                                                        <h4 style="margin: 0 0 4px; font-size: 14px; color: #581c87; font-weight: 500;">Real-time Updates</h4>
                                                        <p style="margin: 0; font-size: 12px; color: #6b7280;">Stay informed</p>
                                                    </td>
                                                    <td style="padding: 12px 8px; width: 33.33%;" align="center">
                                                        <div style="display: inline-block; padding: 12px; background: linear-gradient(135deg, rgba(59, 130, 246, 0.1), rgba(236, 72, 153, 0.1)); border-radius: 50%; margin-bottom: 8px;">
                                                            <img src="https://imaging.oshelter.com/feature3.png" alt="Community Support" width="32" height="32" style="display: block;" />
                                                        </div>
                                                        <h4 style="margin: 0 0 4px; font-size: 14px; color: #581c87; font-weight: 500;">Community Support</h4>
                                                        <p style="margin: 0; font-size: 12px; color: #6b7280;">Connect with others</p>
                                                    </td>
                                                </tr>
                                            </table>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>

                        <!-- Elegant Footer -->
                        <tr>
                            <td style="padding: 0;">
                                <div style="height: 4px; background: linear-gradient(90deg, #ec4899, #a855f7, #3b82f6);"></div>
                                <table role="presentation" width="100%" cellspacing="0" cellpadding="0" border="0" style="background: linear-gradient(135deg, #581c87, #6b46c1);">
                                    <tr>
                                        <td align="center" style="padding: 25px 20px;">
                                            <table role="presentation" width="100%" cellspacing="0" cellpadding="0" border="0">
                                                <tr>
                                                    <td align="center" style="padding: 0 0 15px;">
                                                        <a href="#" style="color: white; margin: 0 8px; text-decoration: none; display: inline-block; transition: transform 0.3s;">
                                                            <div style="width: 36px; height: 36px; background: rgba(255, 255, 255, 0.1); border-radius: 50%; display: flex; align-items: center; justify-content: center;">
                                                                <img src="https://imaging.oshelter.com/facebook.png" alt="Facebook" width="20" height="20" style="display: block;" />
                                                            </div>
                                                        </a>
                                                        <a href="#" style="color: white; margin: 0 8px; text-decoration: none; display: inline-block;">
                                                            <div style="width: 36px; height: 36px; background: rgba(255, 255, 255, 0.1); border-radius: 50%; display: flex; align-items: center; justify-content: center;">
                                                                <img src="https://imaging.oshelter.com/twitter.png" alt="X" width="20" height="20" style="display: block;" />
                                                            </div>
                                                        </a>
                                                        <a href="#" style="color: white; margin: 0 8px; text-decoration: none; display: inline-block;">
                                                            <div style="width: 36px; height: 36px; background: rgba(255, 255, 255, 0.1); border-radius: 50%; display: flex; align-items: center; justify-content: center;">
                                                                <img src="https://imaging.oshelter.com/tiktok.png" alt="TikTok" width="20" height="20" style="display: block;" />
                                                            </div>
                                                        </a>
                                                        <a href="#" style="color: white; margin: 0 8px; text-decoration: none; display: inline-block;">
                                                            <div style="width: 36px; height: 36px; background: rgba(255, 255, 255, 0.1); border-radius: 50%; display: flex; align-items: center; justify-content: center;">
                                                                <img src="https://imaging.oshelter.com/instagram.png" alt="Instagram" width="20" height="20" style="display: block;" />
                                                            </div>
                                                        </a>
                                                        <a href="#" style="color: white; margin: 0 8px; text-decoration: none; display: inline-block;">
                                                            <div style="width: 36px; height: 36px; background: rgba(255, 255, 255, 0.1); border-radius: 50%; display: flex; align-items: center; justify-content: center;">
                                                                <img src="https://imaging.oshelter.com/youtube.png" alt="YouTube" width="20" height="20" style="display: block;" />
                                                            </div>
                                                        </a>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td align="center" style="padding: 0 0 15px;">
                                                        <a href="#" style="color: rgba(255, 255, 255, 0.9); text-decoration: none; font-weight: 400; padding: 5px 12px; margin: 0 2px; border-right: 1px solid rgba(255, 255, 255, 0.2); white-space: nowrap; font-size: 14px;">OShelter</a>
                                                        <a href="#" style="color: rgba(255, 255, 255, 0.9); text-decoration: none; font-weight: 400; padding: 5px 12px; margin: 0 2px; border-right: 1px solid rgba(255, 255, 255, 0.2); white-space: nowrap; font-size: 14px;">About Us</a>
                                                        <a href="#" style="color: rgba(255, 255, 255, 0.9); text-decoration: none; font-weight: 400; padding: 5px 12px; margin: 0 2px; border-right: 1px solid rgba(255, 255, 255, 0.2); white-space: nowrap; font-size: 14px;">Contact Us</a>
                                                        <a href="#" style="color: rgba(255, 255, 255, 0.9); text-decoration: none; font-weight: 400; padding: 5px 12px; margin: 0 2px; white-space: nowrap; font-size: 14px;">FAQ</a>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td align="center" style="padding: 0;">
                                                        <p style="margin: 5px 0; font-size: 12px; line-height: 18px; color: rgba(255, 255, 255, 0.8);">
                                                            You have received this email as a registered user of <span style="font-weight: 500; color: white;">OShelter</span>.
                                                            <br>You can <a href="#" style="color: #f0abfc; text-decoration: none; font-weight: 500;">unsubscribe</a> from these emails here.
                                                        </p>
                                                        <p style="margin: 5px 0; font-size: 12px; line-height: 18px; color: rgba(255, 255, 255, 0.8);">
                                                            Gowa Street, Tentulu - Accra GZ-165-3373
                                                        </p>
                                                        <p style="margin: 15px 0 0; font-size: 11px; color: rgba(255, 255, 255, 0.6);">
                                                            © {{ date('Y') }} OShelter. All rights reserved.
                                                        </p>
                                                    </td>
                                                </tr>
                                            </table>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
    </center>
</body>
</html>