<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\SliderController;
use App\Http\Controllers\ServiceController;
use App\Http\Controllers\PortfolioController;
use App\Http\Controllers\TeamController;
use App\Http\Controllers\SettingController;

/*
|
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::resource('sliders', SliderController::class);
Route::resource('services', ServiceController::class);
Route::resource('portfolios', PortfolioController::class);
Route::resource('teams', TeamController::class);
Route::get('settings', [SettingController::class, 'index']);
Route::post('settings', [SettingController::class, 'store']);
Route::put('settings/{setting}', [SettingController::class, 'update'])->name('settings.update');